import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = { PriceEntered: 1 }
  const token = authToken ?? await getTokenHelper(event)
  const inoutlineId = getRouterParam(event, 'inoutlineId')

  // Step 1: Get C_OrderLine_ID from m_inoutline
  const inoutLineRes: any = await fetchHelper(event, `models/m_inoutline/${inoutlineId}?$select=c_orderline_id`, 'GET', token, null)

  const orderLineId = inoutLineRes?.C_OrderLine_ID?.id
  if (!orderLineId) {
    return data
  }

  // Step 2: Get pricing from c_orderline
  const orderLineRes: any = await fetchHelper(event, `models/c_orderline/${orderLineId}?$select=qtyentered,priceentered`, 'GET', token, null)

  if (orderLineRes) {
    data = {
      PriceEntered: orderLineRes?.PriceEntered || 1
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
